/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal;

import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationAbstractGoal;
import com.eeeab.eeeabsmobs.sever.entity.impl.effect.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.entity.impl.namelessguardian.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;

public class GuardianCombo2Goal
extends AnimationAbstractGoal<EntityNamelessGuardian> {
    private boolean isPowered;
    private final float range;
    private final float attackArc;

    public GuardianCombo2Goal(EntityNamelessGuardian entity, float range, float attackArc) {
        super(entity);
        this.range = range;
        this.attackArc = attackArc;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.isPowered = ((EntityNamelessGuardian)this.entity).m_7090_();
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == EntityNamelessGuardian.ATTACK2_ANIMATION_1 || animation == EntityNamelessGuardian.ATTACK2_ANIMATION_2 || animation == EntityNamelessGuardian.ATTACK2_ANIMATION_3;
    }

    public void m_8037_() {
        Animation animation = ((EntityNamelessGuardian)this.entity).getAnimation();
        LivingEntity target = ((EntityNamelessGuardian)this.entity).m_5448_();
        int tick = ((EntityNamelessGuardian)this.entity).getAnimationTick();
        float baseDamageMultiplier = this.isPowered ? 1.0f : 0.8f;
        ((EntityNamelessGuardian)this.entity).m_20334_(0.0, ((EntityNamelessGuardian)this.entity).m_20096_() ? 0.0 : ((EntityNamelessGuardian)this.entity).m_20184_().f_82480_, 0.0);
        if (animation == EntityNamelessGuardian.ATTACK2_ANIMATION_1) {
            int lookAtFrame;
            int n = lookAtFrame = this.isPowered ? 12 : 8;
            if (tick < lookAtFrame && target != null) {
                ((EntityNamelessGuardian)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityNamelessGuardian)this.entity).m_146922_(((EntityNamelessGuardian)this.entity).f_19859_);
            }
            if (tick == 8) {
                ((EntityNamelessGuardian)this.entity).m_5496_((SoundEvent)SoundInit.NAMELESS_GUARDIAN_WHOOSH.get(), 1.95f, ((EntityNamelessGuardian)this.entity).m_6100_());
            } else if (tick == 11) {
                this.pursuit(5.0f, 1.5f);
            } else if (tick == 12) {
                List<LivingEntity> entities = ((EntityNamelessGuardian)this.entity).getNearByLivingEntities(this.range);
                for (LivingEntity hitEntity : entities) {
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, hitEntity);
                    float entityHitDistance = (float)Math.sqrt((hitEntity.m_20189_() - ((EntityNamelessGuardian)this.entity).m_20189_()) * (hitEntity.m_20189_() - ((EntityNamelessGuardian)this.entity).m_20189_()) + (hitEntity.m_20185_() - ((EntityNamelessGuardian)this.entity).m_20185_()) * (hitEntity.m_20185_() - ((EntityNamelessGuardian)this.entity).m_20185_())) - hitEntity.m_20205_() / 2.0f;
                    if (!(entityHitDistance <= this.range && entityRelativeAngle <= (this.attackArc + 70.0f) / 2.0f && entityRelativeAngle >= -(this.attackArc - 20.0f) / 2.0f || entityRelativeAngle >= 360.0f - this.attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.attackArc / 2.0f)) continue;
                    ((EntityNamelessGuardian)this.entity).guardianHurtTarget((EntityNamelessGuardian)this.entity, hitEntity, 0.025f, 1.0f, baseDamageMultiplier, true, true);
                    hitEntity.m_20256_(hitEntity.m_20184_().m_82520_(0.0, 0.6, 0.0));
                    ((EntityNamelessGuardian)this.entity).m_5496_((SoundEvent)SoundInit.GIANT_AXE_HIT.get(), 1.5f, 0.2f);
                }
            } else if (tick == 20 && ((EntityNamelessGuardian)this.entity).checkCanAttackRange(2.0, this.range) && this.canToggleAnimation(80)) {
                ((EntityNamelessGuardian)this.entity).playAnimation(EntityNamelessGuardian.ATTACK2_ANIMATION_2);
            }
        } else if (animation == EntityNamelessGuardian.ATTACK2_ANIMATION_2) {
            int lookAtFrame;
            tick = ((EntityNamelessGuardian)this.entity).getAnimationTick();
            int n = lookAtFrame = this.isPowered ? 10 : 4;
            if (tick < lookAtFrame && target != null) {
                ((EntityNamelessGuardian)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityNamelessGuardian)this.entity).m_146922_(((EntityNamelessGuardian)this.entity).f_19859_);
            }
            if (tick == 5) {
                this.pursuit(-1.0f, 1.4f);
            } else if (tick == 6) {
                ((EntityNamelessGuardian)this.entity).m_5496_((SoundEvent)SoundInit.NAMELESS_GUARDIAN_WHOOSH.get(), 2.05f, ((EntityNamelessGuardian)this.entity).m_6100_() + 0.15f);
            } else if (tick == 10) {
                List<LivingEntity> entities = ((EntityNamelessGuardian)this.entity).getNearByLivingEntities(this.range);
                for (LivingEntity hitEntity : entities) {
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, hitEntity);
                    float entityHitDistance = (float)Math.sqrt((hitEntity.m_20189_() - ((EntityNamelessGuardian)this.entity).m_20189_()) * (hitEntity.m_20189_() - ((EntityNamelessGuardian)this.entity).m_20189_()) + (hitEntity.m_20185_() - ((EntityNamelessGuardian)this.entity).m_20185_()) * (hitEntity.m_20185_() - ((EntityNamelessGuardian)this.entity).m_20185_())) - hitEntity.m_20205_() / 2.0f;
                    if (!(entityHitDistance <= this.range && entityRelativeAngle <= (this.attackArc + 20.0f) / 2.0f && entityRelativeAngle >= -(this.attackArc + 20.0f) / 2.0f || entityRelativeAngle >= 360.0f - this.attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.attackArc / 2.0f)) continue;
                    ((EntityNamelessGuardian)this.entity).guardianHurtTarget((EntityNamelessGuardian)this.entity, hitEntity, 0.025f, 1.0f, baseDamageMultiplier, true, true);
                    ((EntityNamelessGuardian)this.entity).m_5496_((SoundEvent)SoundInit.GIANT_AXE_HIT.get(), 1.5f, 0.2f);
                    double ratioX = Math.sin(((EntityNamelessGuardian)this.entity).m_146908_() * ((float)Math.PI / 180));
                    double ratioZ = -Math.cos(((EntityNamelessGuardian)this.entity).m_146908_() * ((float)Math.PI / 180));
                    ModEntityUtils.forceKnockBack(hitEntity, 0.5f, ratioX, ratioZ, 1.0, false);
                }
            } else if (tick == 20 && ((EntityNamelessGuardian)this.entity).checkCanAttackRange(2.5, this.range) && this.canToggleAnimation(70)) {
                ((EntityNamelessGuardian)this.entity).playAnimation(EntityNamelessGuardian.ATTACK2_ANIMATION_3);
            }
        } else if (animation == EntityNamelessGuardian.ATTACK2_ANIMATION_3) {
            int lookAtFrame;
            tick = ((EntityNamelessGuardian)this.entity).getAnimationTick();
            baseDamageMultiplier += 0.2f;
            int n = lookAtFrame = this.isPowered ? 14 : 12;
            if (tick < lookAtFrame && target != null) {
                ((EntityNamelessGuardian)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityNamelessGuardian)this.entity).m_146922_(((EntityNamelessGuardian)this.entity).f_19859_);
            }
            if (tick == 7) {
                this.pursuit(5.0f, 2.5f);
            } else if (tick == 10) {
                ((EntityNamelessGuardian)this.entity).m_5496_((SoundEvent)SoundInit.NAMELESS_GUARDIAN_WHOOSH.get(), 2.2f, ((EntityNamelessGuardian)this.entity).m_6100_() + 0.15f);
            } else if (tick == 14) {
                float attackArc = 30.0f;
                float range = 5.2f;
                List<LivingEntity> entities = ((EntityNamelessGuardian)this.entity).getNearByLivingEntities(5.2f, 4.6f, 5.2f, 5.2f);
                for (LivingEntity livingEntity : entities) {
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, livingEntity);
                    float entityHitDistance = (float)Math.sqrt((livingEntity.m_20189_() - ((EntityNamelessGuardian)this.entity).m_20189_()) * (livingEntity.m_20189_() - ((EntityNamelessGuardian)this.entity).m_20189_()) + (livingEntity.m_20185_() - ((EntityNamelessGuardian)this.entity).m_20185_()) * (livingEntity.m_20185_() - ((EntityNamelessGuardian)this.entity).m_20185_())) - livingEntity.m_20205_() / 2.0f;
                    if (!(entityHitDistance <= 5.2f && entityRelativeAngle <= 15.0f && entityRelativeAngle >= -15.0f || entityRelativeAngle >= 345.0f) && !(entityRelativeAngle <= -345.0f)) continue;
                    ((EntityNamelessGuardian)this.entity).guardianHurtTarget((EntityNamelessGuardian)this.entity, livingEntity, 0.025f, 1.0f, baseDamageMultiplier, true, true);
                }
            } else if (tick == 15) {
                ((EntityNamelessGuardian)this.entity).m_5496_((SoundEvent)SoundInit.GIANT_AXE_HIT.get(), 2.0f, 0.2f);
            } else if (tick == 16) {
                ((EntityNamelessGuardian)this.entity).m_5496_(SoundEvents.f_11913_, 1.25f, 1.0f + ((EntityNamelessGuardian)this.entity).m_217043_().m_188501_() * 0.1f);
                EntityCameraShake.cameraShake(((EntityNamelessGuardian)this.entity).f_19853_, ((EntityNamelessGuardian)this.entity).m_20182_(), 20.0f, 0.125f, 5, 10);
            }
        }
    }

    private boolean canToggleAnimation(int healthPercentage) {
        return !this.isPowered && (((EntityNamelessGuardian)this.entity).getHealthPercentage() >= (float)healthPercentage && ((EntityNamelessGuardian)this.entity).m_217043_().m_188501_() < 0.4f || ((EntityNamelessGuardian)this.entity).getHealthPercentage() < (float)healthPercentage && ((EntityNamelessGuardian)this.entity).m_217043_().m_188501_() < 0.6f) || this.isPowered && ((EntityNamelessGuardian)this.entity).m_217043_().m_188501_() < 0.9f;
    }

    private void pursuit(float pursuitDistance, float moveMultiplier) {
        float targetDistance = ((EntityNamelessGuardian)this.entity).targetDistance;
        if (((EntityNamelessGuardian)this.entity).m_5448_() != null && targetDistance < pursuitDistance && targetDistance > 0.0f) {
            moveMultiplier = targetDistance -= 1.0f;
        }
        targetDistance = ((EntityNamelessGuardian)this.entity).targetDistance;
        if (((EntityNamelessGuardian)this.entity).m_5448_() == null || targetDistance > 1.8f) {
            ((EntityNamelessGuardian)this.entity).m_6478_(MoverType.SELF, new Vec3(Math.cos(Math.toRadians(((EntityNamelessGuardian)this.entity).m_146908_() + 90.0f)) * (double)moveMultiplier, 0.0, Math.sin(Math.toRadians(((EntityNamelessGuardian)this.entity).m_146908_() + 90.0f)) * (double)moveMultiplier));
        }
    }
}

